/*
 * Copyright (C) 2025 Hiroki Sato
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3.
 *
 * This program uses Arduino SD library
 * Copyright (C) Yoshino Taro
 */

#include <Arduino.h>
#include <Camera.h>
#include <SPI.h>
#include <SPISD.h>

/* =========================================================
   [U[ݒ
   ========================================================= */

/*
  BeԊui~bj
   - 10b   : 10000
   - 1    : 60000
   - 10   : 600000
*/
const unsigned long WAIT_INTERVAL_MS = 600000;

/*
  }CNSDJ[hdsǂ
   true  : D25PMOSQ[g
   false : SDJ[h펞ʓd
*/
const bool USE_SD_POWER_CONTROL = false;

/*
  PMOS Q[gs
   H : SDJ[hd OFF
   L : SDJ[hd ON
*/
const int SD_POWER_PIN = 25;

/* ========================================================= */

SpiSDClass SD(SPI5);
static int gCounter = 0;

void setup() {
  Serial.begin(115200);
  while (!Serial);

  Serial.println("=== SPRESENSE Timelapse ===");

  /* ---- SD ds ---- */
  if (USE_SD_POWER_CONTROL) {
    pinMode(SD_POWER_PIN, OUTPUT);
    digitalWrite(SD_POWER_PIN, HIGH);   // SD d OFF
  }

  /* ---- SD  ---- */
  if (USE_SD_POWER_CONTROL) {
    digitalWrite(SD_POWER_PIN, LOW);    // SD d ON
    delay(100);
  }

  Serial.print("Initializing SD card... ");
  if (!SD.begin(SPI_FULL_SPEED)) {
    Serial.println("FAILED!");
    while (1);
  }
  Serial.println("OK");

  if (USE_SD_POWER_CONTROL) {
    digitalWrite(SD_POWER_PIN, HIGH);   // SD d OFF
  }

  /* ---- Camera  ---- */
  Serial.print("Initializing Camera... ");
  CamErr err = theCamera.begin();
  if (err != CAM_ERR_SUCCESS) {
    Serial.print("FAILED: ");
    Serial.println(err);
    while (1);
  }
  Serial.println("OK");

  theCamera.setStillPictureImageFormat(
    CAM_IMGSIZE_VGA_H,
    CAM_IMGSIZE_VGA_V,
    CAM_IMAGE_PIX_FMT_JPG
  );

  Serial.println("Setup completed.");
}

void loop() {

  /* ---- ҋ@---- */
  if (USE_SD_POWER_CONTROL) {
    digitalWrite(SD_POWER_PIN, HIGH);   // SD d OFF
  }

  delay(WAIT_INTERVAL_MS);

  /* ---- Be---- */

  Serial.println("Taking picture...");
  CamImage img = theCamera.takePicture();

  if (!img.isAvailable()) {
    Serial.println("Camera capture FAILED!");
    return;
  }


  /* ---- }CNSDJ[h  ---- */

  char filename[16];
  sprintf(filename, "PICT%03d.JPG", gCounter);

  if (USE_SD_POWER_CONTROL) {
    digitalWrite(SD_POWER_PIN, LOW);    // SD d ON
    delay(100);
  }

  SpiFile myFile = SD.open(filename, FILE_WRITE);
  if (!myFile) {
    Serial.println("Failed to open file!");
    if (USE_SD_POWER_CONTROL) {
      digitalWrite(SD_POWER_PIN, HIGH);
    }
    return;
  }

  myFile.write(img.getImgBuff(), img.getImgSize());
  myFile.close();

  if (USE_SD_POWER_CONTROL) {
    digitalWrite(SD_POWER_PIN, HIGH);   // SD d OFF
  }

  Serial.println("Picture saved.");
  gCounter++;
}
